<?php require_once("../../db.php"); ?>
<?php try {
		$results = array();
		$core = Core::getInstance();
		$stmt = $core->dbh->prepare("SELECT * FROM myclients WHERE client_id = :client_id");
		$stmt -> bindParam("client_id", $_GET["id"]);
		$stmt -> execute();
		$results = $stmt -> fetch(PDO::FETCH_ASSOC);
		
		// query how many bulks
		$stmt_blk = $core->dbh->prepare("SELECT count(*) as sum FROM messages WHERE mess_client_id = :mess_client_id and mess_blk = '1'");
		$stmt_blk -> bindParam("mess_client_id", $_GET["id"]);
		$stmt_blk -> execute();
		$result_blk = $stmt_blk -> fetch(PDO::FETCH_ASSOC);
		$results["blk"] = $result_blk["sum"];
		
		// query total messages received
		$stmt_tot_received = $core->dbh->prepare("SELECT count(*) as sum FROM messages WHERE mess_client_id = :mess_client_id and mess_whosent = '0'");
		$stmt_tot_received -> bindParam("mess_client_id", $_GET["id"]);
		$stmt_tot_received -> execute();
		$result_tot_received = $stmt_tot_received -> fetch(PDO::FETCH_ASSOC);
		$results["tot_received"] = $result_tot_received["sum"];
		
		//query how many messages received in last 24 hours
		$stmt_24 = $core->dbh->prepare("SELECT count(*) as sum FROM messages WHERE mess_client_id = :mess_client_id and mess_whosent = '0' and mess_date > now() - interval 24 hour");
		$stmt_24 -> bindParam("mess_client_id", $_GET["id"]);
		$stmt_24 -> execute();
		$result_24 = $stmt_24 -> fetch(PDO::FETCH_ASSOC);
		$results["sum_24h"] = $result_24["sum"];
		
		echo json_encode($results);	
		
	} catch(PDOException $pe) {
		trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
	}
?>